/*******************************************************************/
/*                                                                 */
/*                      ADOBE CONFIDENTIAL                         */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                     */
/*                                                                 */
/* Copyright 1986 - 2000 Adobe Systems Incorporated                */
/* All Rights Reserved.                                            */
/*                                                                 */
/* NOTICE:  All information contained herein is, and remains the   */
/* property of Adobe Systems Incorporated and its suppliers, if    */
/* any.  The intellectual and technical concepts contained         */
/* herein are proprietary to Adobe Systems Incorporated and its    */
/* suppliers and may be covered by U.S. and Foreign Patents,       */
/* patents in process, and are protected by trade secret or        */
/* copyright law.  Dissemination of this information or            */
/* reproduction of this material is strictly forbidden unless      */
/* prior written permission is obtained from Adobe Systems         */
/* Incorporated.                                                   */
/*                                                                 */
/*******************************************************************/
//-------------------------------------------------------------------
/*
 * Name:
 *	PIChannelPortOperations.h
 *
 * Copyright 1986-2000 Adobe Systems Incorporated.
 * All Rights Reserved.
 *
 * Purpose:
 *	Documents supported imaging operations on channel ports.
 *
 * Distribution:
 *	PUBLIC
 */

#ifndef __PIChannelPortOperations__
#define __PIChannelPortOperations__

#include "PIGeneral.h"

#ifdef __cplusplus
extern "C" {
#endif

/******************************************************************************/

/* Gaussian blur from the source to the destination. */

#define PSChannelPortGaussianBlurFilter "Photoshop Gaussian Blur Filter"

struct PSGaussianBlurParameters
	{
	Fixed radius;	// Radius in pixels using 16.16 fixed point values. 0 to 250 supported.
	int32 padding;	// 0-255 for constant padding. -1 for edge replication.
	};

/******************************************************************************/

/* Min, Max, and Median filters. */

#define PSChannelPortMinimumFilter "Photoshop Minimum Filter"
#define PSChannelPortMaximumFilter "Photoshop Maximum Filter"
#define PSChannelPortMedianFilter  "Photoshop Median Filter"

struct PSMinMaxMedianParameters
	{
	int32 radius;	// Radius in pixels. 1-16 supported for median. 1-10 for min and max.
	int32 padding;	// 0-255 for constant padding. -1 for edge replication.
	};

/******************************************************************************/

/* Copy source to destination. If rect is specified it will define the bounds
to process. It will be restricted to the actual writable bounds. It ignores
the mask parameter. */

#define PSChannelPortCopyPixels "Photoshop Copy Pixels"

/******************************************************************************/

/* Set pixels to a given value. Only implemented for depth 8. */

#define PSChannelPortSetPixels "Photoshop Set Pixels"

struct PSChannelPortSetPixelsParameters
	{
	int32 value;	// 0-255
	};

/******************************************************************************/

#ifdef __cplusplus
}
#endif


#endif	// PIChannelPortOperations
